<?php
/**
 * @package گوگل استار
 * @version 1.1
 */
/*
Plugin Name: Google Rich Snippets
Version: 1.3.1.1
Plugin URI: http://www.hamyarwp.com
Description: Free Wordpress plugin For make Google Rich Snippets
Author: hamuarwp
Author URI: http://www.hamyarwp.com
*/

$prefix = 'pk_rs_';

// if you use this plugin in autoblog, you might one to set the default rating below to something other then 0, ex: 3.5
DEFINE ('PK_RS_DEFAULT_RATING', '-');

// hiding the product rating might be considered as grey/black hat, set display as true to show it to the visitor
DEFINE ('PK_RS_DISPLAY', false);
$pk_rs_meta_box = array(
	'id' => 'pk_rich_snippet_review',
	'title' => 'گوگل استار',
	'page' => 'post',
	'context' => 'normal',
	'priority' => 'high',
	'fields' => array(
		array(
			'name' => 'رتبه',
			'desc' => 'رتبه به مطلب ، از شماره 1 تا 5.',
			'id' => 'rating',
			'type' => 'select',
			'options' => array('-', '1.0', '1.5', '2.0', '2.5', '3.0', '3.5', '4.0', '4.5', '5.0')
		),	
		array(
			'name' => 'نویسنده',
			'desc' => 'نمایش نام نویسنده',
			'id' => 'author',
			'type' => 'text',
			'std' => ''
		),		
		array(
			'name' => 'عنوان',
			'desc' => 'توضیح کوتاه (حدود یک خط)',
			'id' => 'summary',
			'type' => 'text',
			'std' => ''
		),
		array(
			'name' => 'توضیح',
			'desc' => 'یک  پاراگراف بنویسید',
			'id' => 'description',
			'type' => 'textarea',
			'std' => ''
		)
	
	)
);

add_action('admin_menu', 'pk_rich_snippet_add_box');

// افزودن کد متا
function pk_rich_snippet_add_box() {
	global $pk_rs_meta_box;
	
	add_meta_box($pk_rs_meta_box['id'], $pk_rs_meta_box['title'], 'pk_rich_snippet_show_box', $pk_rs_meta_box['page'], $pk_rs_meta_box['context'], $pk_rs_meta_box['priority']);
}

// صدا زدن تابع
function pk_rich_snippet_show_box() {
	global $pk_rs_meta_box, $post;
	
	// Use nonce for verification
	echo '<input type="hidden" name="pk_rich_snippet_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
	
	echo '<table class="form-table">';

	foreach ($pk_rs_meta_box['fields'] as $field) {
		// get current post meta data
		$meta = get_post_meta($post->ID, $field['id'], true);
		
		echo '<tr>',
				'<th style="width:20%"><label for="', $field['id'], '">', $field['name'], '</label></th>',
				'<td>';
		switch ($field['type']) {
			case 'text':
				echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta : $field['std'], '" size="30" style="width:97%" />',
					'<br />', $field['desc'];
				break;
			case 'textarea':
				echo '<textarea name="', $field['id'], '" id="', $field['id'], '" cols="60" rows="4" style="width:97%">', $meta ? $meta : $field['std'], '</textarea>',
					'<br />', $field['desc'];
				break;
			case 'select':
				echo '<select name="', $field['id'], '" id="', $field['id'], '">';
				foreach ($field['options'] as $option) {
					echo '<option', $meta == $option ? ' selected="selected"' : '', '>', $option, '</option>';
				}
				echo '</select>', '<br />', $field['desc'];
				break;
			case 'radio':
				foreach ($field['options'] as $option) {
					echo '<input type="radio" name="', $field['id'], '" value="', $option['value'], '"', $meta == $option['value'] ? ' checked="checked"' : '', ' />', $option['name'];
				}
				break;
			case 'checkbox':
				echo '<input type="checkbox" name="', $field['id'], '" id="', $field['id'], '"', $meta ? ' checked="checked"' : '', ' />', 
				'<br />', $field['desc'];
				break;
		}
		echo 	'<td>',
			'</tr>';
	}
	
	echo '</table>';
}

add_action('save_post', 'pk_rs_save_data');

// نمایش داده ها
function pk_rs_save_data($post_id) {
	global $pk_rs_meta_box;
	
	// verify nonce
	if (!wp_verify_nonce($_POST['pk_rich_snippet_nonce'], basename(__FILE__))) {
		return $post_id;
	}

	// check autosave
	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
		return $post_id;
	}

	// check permissions
	if ('page' == $_POST['post_type']) {
		if (!current_user_can('edit_page', $post_id)) {
			return $post_id;
		}
	} elseif (!current_user_can('edit_post', $post_id)) {
		return $post_id;
	}
	
	foreach ($pk_rs_meta_box['fields'] as $field) {
		$old = get_post_meta($post_id, $field['id'], true);
		$new = $_POST[$field['id']];
		
		if ($new && $new != $old) {
			update_post_meta($post_id, $field['id'], $new);
		} elseif ('' == $new && $old) {
			delete_post_meta($post_id, $field['id'], $old);
		}
	}
}

add_filter('the_content', 'pk_rs_add_rich_snippet_to_content', 20);
function pk_rs_add_rich_snippet_to_content($content){
	if (is_single()&&!is_feed()){
		global $post;
		$rating = get_post_meta($post->ID, 'rating', true);	
		$rating = ( '-' == $rating && '-' != PK_RS_DEFAULT_RATING ) ? PK_RS_DEFAULT_RATING : $rating;  
		if ( '-' != $rating ){
			$title = $post->post_title ;
			$dateTime = date_create( $post->post_date );
			$date = $dateTime->format("Y-m-d");
			$date_only = $dateTime->format("M j");
			$author = get_post_meta($post->ID, 'author', true);
			$author = ( '' == $author ) ? ucfirst(get_the_author_meta('display_name', $post->post_author)) : $author;
			$summary = get_post_meta($post->ID, 'summary', true);
			$description = get_post_meta($post->ID, 'description', true);
			if ( !PK_RS_DISPLAY ) {
				$output = "<div class=\"hreview\"  style=\"width:5px; height: 5px; overflow:scroll; margin-top:-5px;\">";
				$output .= "<span class=\"item\"><span class=\"fn entry-title\">".$title."</span></span>";
				$output .= "Reviewed by <span class=\"reviewer\">".$author."</span> on <span class=\"dtreviewed\"> ".$date_only."<span class=\"value-title\" title=\"".$date."\"></span></span>";
				$output .= "Rating: <span class=\"rating\">".$rating."</span>";			
				$output .= "<span class=\"summary\">".$summary."</span>";
				$output .= "<span class=\"description\">".$description."</span>";
				$output .= "</div>";
			} else {
				$output = "<div class=\"hreview\" style=\"display:block; margin: 0 0 10px 10px; padding: 10px; background: #F6F6F6; border: 1px solid #DDD; -moz-border-radius: 3px; border-radius: 3px; font-size: 0.8em; width: 30%; float: right;\">";
				$output .= "Title: <span class=\"item\"><span class=\"fn entry-title\" style=\"font-size: 0.8em;font-weight: normal;\">".$title."</span></span><br />";
				$output .= "Reviewed by <span class=\"reviewer\">".$author."</span> on <span class=\"dtreviewed\"> ".$date_only."<span class=\"value-title\" title=\"".$date."\"></span></span><br/>";
				$output .= "Rating: <span class=\"rating\">".$rating."</span><br/>";			
				$output .= ( 0 < strlen($summary) ) ? "Summary: <span class=\"summary\">".$summary."</span><br/>" : "";
				$output .= ( 0 < strlen($description) ) ? "<p><span class=\"description\">".$description."</span></p>" : "";
				$output .= "</div>";
			}
			
			$content = $output.$content ;
		}
	}
	return $content;
}

?>